package cn.com.duiba.kjy.api.dto.config;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 类似hbase的键值对配置表
 * @author kjj mybatis generator 
 * 2020-08-11
 */
@Data
public class KeyToValConfDto implements Serializable {
    private static final long serialVersionUID = 15971113154333559L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *单一属性,一般为原先hbase的key
     * max length = 125
     * not null default = null
     */
    private String itemId;

    /**
     *
     *单一属性对应的long类型的值
     */
    private Long itemValLong;

    /**
     *
     *单一属性对应的varchar类型的值
     * max length = 512
     */
    private String itemValStr;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}