package cn.com.duiba.kjy.api.enums.explosioncontent;

import lombok.Getter;

/**
 * 焦虑类型枚举
 * @author xiaotian
 * @date 2020-07-13 17:57
 **/
@Getter
public enum AnxietyEnum {

    CHILD(1,"育儿焦虑","少儿成长投保攻略"),
    ASSET(2,"财产焦虑","资产规划投保攻略"),
    MIDDLE_AGE(3,"中年焦虑","家庭安全投保攻略"),
    ACCIDENT(4,"意外焦虑","意外防范投保攻略"),
    HEALTH(5,"健康焦虑","健康无忧投保攻略"),
    OLD(6,"养老焦虑","老年保障投保攻略")
    ;
    private Integer code;
    private String desc;
    private String materialDesc;

    AnxietyEnum(Integer code, String desc,String materialDesc) {
        this.code = code;
        this.desc = desc;
        this.materialDesc = materialDesc;
    }

    public static AnxietyEnum  getByCode(Integer code){
        for (AnxietyEnum anxietyEnum : AnxietyEnum.values()){
            if(anxietyEnum.getCode().equals(code)){
                return anxietyEnum;
            }
        }
        return null;
    }

}
