package cn.com.duiba.kjy.api.enums.push;

import org.apache.commons.lang3.StringUtils;

/**
 * 推送事件
 * @author lizhi
 * @date 2019/7/10 3:21 PM
 */
public enum  PushEventEnum {


    LIVE_USER_APPOINTMENT("L5", "直播开播用户订阅消息"),
    LIVE_NOTIFY_AGENT_IN_NOTICE_TIME("L1","在直播配置的通知时间通知代理人(客服)"),
    LIVE_NOTIFY_AGENT_BEFORE_BEGIN("L2","在直播开始前3分钟通知代理人(客服)"),
    LIVE_NOTIFY_AGENT_WHEN_LIVING("L3","在直播开始中每20分钟通知一次代理人(客服)"),
    LIVE_NOTIFY_AGENT_WHEN_LIVED("L4","在直播结束将统计数据发给代理人(客服)"),
    LIVE_OA_QR_CODE_RESOURCE("L9","直播公众号资料推送"),
    LIVE_OUT_LINK("L10","直播外部链接推送"),

    LIVE_USER_APPOINTMENT_LOTTERY("L17", "直播预约活动开奖通知"),
    LIVE_USER_APPOINTMENT_RED("L18", "直播预约红包领取通知"),
    LIVE_USER_APPOINTMENT_SUBSCRIBE("L19", "直播开播用户订阅关注消息"),
    LIVE_AGENT_STATISTIC_PUSH_BEFORE_START("L20", "开播前,非直播当天代理人邀请/预约数据统计推送"),
    LIVE_AGENT_RANK_PUSH_BEFORE_START("L21", "开播前,代理人排行推送"),
    LIVE_AGENT_INVITE_USER_PUSH_BEFORE_START("L22", "开播前,代理人邀请用户,每10分钟聚合推送"),
    LIVE_USER_APPOINTMENT_PRE_LOTTERY("L23", "直播前中奖通知"),
    LIVE_AGENT_VISITOR_PRE_LOTTERY("L24", "代理人访客直播前中奖通知"),
    LIVE_DRAW_AWARD_AGENT_PUSH("L26", "直播间开奖，中奖客户代理人聚合消息推送"),
    LIVE_USER_APPOINTMENT_GUIDE_BOOM("L27", "用户预约预热轴爆款商品推送"),
    LIVE_INDEX_OA_QR_CODE("L28","首页公众号图片推送"),

    OFFER_PRIZES("L29", "邀约有奖推送"),
    ;

    /**
     * 推送事件类型（值为推送需求中的推送ID）
     */
    private String eventType;

    /**
     * 推送事件描述
     */
    private String desc;

    PushEventEnum(String eventType, String desc) {
        this.eventType = eventType;
        this.desc = desc;
    }

    public String getEventType() {
        return eventType;
    }

    public String getDesc() {
        return desc;
    }

    public static PushEventEnum getByEventType(String pushEvent){
        if(StringUtils.isBlank(pushEvent)){
            return null;
        }
        for (PushEventEnum event :values()){
            if(StringUtils.equals(pushEvent,event.getEventType())){
                return event;
            }
        }
        return null;
    }
}
