package cn.com.duiba.kjy.api.enums;

import java.util.Objects;

/**
 * Created by dugq on 2019-06-29.
 * 消息配置的标记。一个功能一个标记。切勿重复哦
 */
public enum MessageMarkEnum {


    LIVE_USER_APPOINTMENT(140, "直播开播用户订阅消息"),
    LIVE_USER_DRAW(141, "访客领取权益订阅消息推送"),
    LIVE_USER_APPOINTMENT_LOTTERY(142, "直播预约活动开奖通知"),
    LIVE_USER_APPOINTMENT_RED(143, "直播预约红包领取通知"),
    LIVE_USER_APPOINTMENT_SUBSCRIBE(144, "直播开播用户订阅关注消息"),
    LIVE_AGENT_VISITOR_PRE_LOTTERY(145, "代理人访客直播前中奖通知"),
    LIVE_USER_APPOINTMENT_GUIDE_BOOM(146, "用户预约预热轴爆款商品"),
    OFFER_PRIZES(147, "邀约有奖"),
    SECKILL_APPOINTMENT(148, "秒杀预约推送"),
    COUPON_USAGE_REMINDER(149, "优惠券使用提醒"),

    /**
     * 唤醒推送
     */
    WAKE_UP_PUSH(176,"唤醒推送客服消息"),
    WAKE_UP_PUSH_TEMPLATE(177,"唤醒推送模版消息"),

    LIVE_AGENT_POSTER_LIVING_TEXT(180, "直播代理人海报直播中文字消息"),
    LIVE_AGENT_POSTER_LIVING_TEMPLATE(181, "直播代理人海报直播中文字消息降级模板消息"),
    LIVE_AGENT_POSTER_WAIT_TEXT(182, "直播代理人海报直播未开始文字消息"),
    LIVE_AGENT_POSTER_WAIT_TEMPLATE(183, "直播代理人海报直播未开始降级模板"),


    LIVE_AGENT_STATISTIC_PUSH_BEFORE_START(190, "开播前,非直播当天代理人邀请/预约数据统计推送模板"),
    LIVE_AGENT_RANK_PUSH_BEFORE_START(191, "开播前,代理人排行推送模板"),
    LIVE_AGENT_INVITE_USER_PUSH_BEFORE_START(192, "开播前,代理人邀请用户,每10分钟聚合推送模板"),
    LIVE_END_AGENT_CLUE_PUSH(193, "直播结束给代理人发线索推送"),

    ;
    private Integer mark;
    private String desc;

    MessageMarkEnum(Integer mark, String desc) {
        this.mark = mark;
        this.desc = desc;
    }

    public Integer getMark() {
        return mark;
    }

    public String getDesc() {
        return desc;
    }

    public static MessageMarkEnum Of(Integer type) {
        for (MessageMarkEnum e :values())
            if (Objects.equals(type, e.getMark())) {
                return e;
            }
        throw new UnsupportedOperationException("不支持的消息");
    }

}
