package cn.com.duiba.kjy.api.remoteservice.link.promotion;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.link.promotion.LinkPromotionConfDto;
import cn.com.duiba.kjy.api.params.link.promotion.LinkPromotionConfQueryParam;

import java.util.List;

/**
 * @author zhuenhui
 * @date 2022/03/21 12:41
 * @description 外链推广配置 RPC
 */
@AdvancedFeignClient
public interface RemoteLinkPromotionConfService {

    /**
     * 新增
     *
     * @param dto 外链推广配置详情
     * @return 执行结果
     */
    int insert(LinkPromotionConfDto dto);

    /**
     * 更新
     *
     * @param dto 外链推广配置详情
     * @return 执行结果
     */
    int update(LinkPromotionConfDto dto);

    /**
     * 查询符合条件的记录的总记录数
     *
     * @param param 查询条件
     * @return 总记录数
     */
    int count(LinkPromotionConfQueryParam param);

    /**
     * 查询符合条件的记录
     *
     * @param param 查询条件
     * @return 配置列表
     */
    List<LinkPromotionConfDto> page(LinkPromotionConfQueryParam param);

    /**
     * 根据主键查询
     *
     * @param id 主键Id
     * @return 外链推广配置详情
     */
    LinkPromotionConfDto findById(Long id);
}
