package cn.com.duiba.kjy.api.util;

import org.apache.commons.lang3.StringUtils;

/**
 * @author zhuenhui
 * @date 2022/02/11 14:02
 * @description 小程序openId转化（仅供中信总行小程序使用）
 */
public class CiticOpenIdConvertUtil {

    private CiticOpenIdConvertUtil() {
    }

    /**
     * 中信总行 用户删除标记
     */
    public static final String CITIC_MARK = "-d-c-";

    /**
     * 标记删除
     */
    public static String remark(String openId) {
        if (StringUtils.isBlank(openId)) {
            return "";
        }
        return StringUtils.join(CITIC_MARK, openId);
    }

    /**
     * 恢复正常的openId
     */
    public static String recover(String openId) {
        if (StringUtils.isBlank(openId)) {
            return "";
        }
        // 不是指定前缀则忽略
        if (!openId.startsWith(CITIC_MARK)) {
            return openId;
        }
        return openId.substring(CITIC_MARK.length());
    }

}
