package cn.com.duiba.kjy.livecenter.api.enums.live;

import cn.com.duiba.kjy.livecenter.api.util.NumberUtil;
import com.google.common.collect.Lists;

import java.util.List;

/**
 * 直播互动类型枚举
 * @author 吴文哲
 * @date 2020-04-02 15:07
 **/
public enum LiveInteractTypeEnum {

    MATERIAL(1,"图文资料"),
    QUESTION(2,"问题"),
    SUBSCRIBE(3,"关注直播间"),
    ACCUMULATE_READ(4,"累计观看"),
    FRIEND_INVITE(5,"邀请好友"),
    FREE_GET(6,"免费领"),
    GRAB_WELFARE(7,"抢权益"),
    CHOICE(8,"测一测"),
    LINK_RESOURCE(9,"链接资料"),
    OA_RESOURCE(10,"公众号资料"),
    FREE_RESOURCE(11, "免费领资料"),
    FORM_RESOURCE(12, "表单资料"),
    WELFARE_RAIN(13,"福利雨"),
            ;

    /**
     * 类型
     */
    private Integer type;

    /**
     * 描述
     */
    private String desc;

    LiveInteractTypeEnum(Integer type ,String desc){
        this.type  = type;
        this.desc  = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 我的福利列表权益类型
     */
    public static List<Integer> welfareTypes = Lists.newArrayList();

    static {
        welfareTypes.addAll(Lists.newArrayList(SUBSCRIBE.getType(),ACCUMULATE_READ.getType(),FRIEND_INVITE.getType(),FREE_GET.getType(),GRAB_WELFARE.getType(), MATERIAL.getType(), LINK_RESOURCE.getType()));
    }

    public static boolean isWelfare(Integer type){
        if(NumberUtil.isNullOrLteZero(type)){
            return false;
        }
        return welfareTypes.contains(type);
    }

    /**
     * 资料类型
     * @deprecated  ！important 以前把以资料结尾的几种具体类型，放一个集合中，统称为【资料】，但随着业务发展此定义不再适用。
     * ！important 在具体使用时，根据需求组装自己的集合
     */
    @Deprecated
    public static final List<Integer> resourceTypes = Lists.newArrayList();

    static {
        resourceTypes.addAll(Lists.newArrayList(MATERIAL.getType(), LINK_RESOURCE.getType(), OA_RESOURCE.getType(), FREE_RESOURCE.getType(), FORM_RESOURCE.getType()));
    }

    public static boolean isResource(Integer type){
        if(NumberUtil.isNullOrLteZero(type)){
            return false;
        }
        return resourceTypes.contains(type);
    }

    /**
     * 权益库类型
     */
    public static List<Integer> welfareTableTypes = Lists.newArrayList();

    static {
        welfareTableTypes.addAll(Lists.newArrayList(SUBSCRIBE.getType(),ACCUMULATE_READ.getType(),FRIEND_INVITE.getType(),FREE_GET.getType(),GRAB_WELFARE.getType()));
    }

    public static boolean isWelfareTable(Integer type){
        if(NumberUtil.isNullOrLteZero(type)){
            return false;
        }
        return welfareTableTypes.contains(type);
    }

    /**
     * 优质线索权益类型
     */
    private static List<Integer> highQualityWelfareTypes = Lists.newArrayList();

    static {
        highQualityWelfareTypes.addAll(Lists.newArrayList(GRAB_WELFARE.getType(), FREE_GET.getType()));
    }

    public static List<Integer> getHighQualityWelfareTypes() {
        return highQualityWelfareTypes;
    }

    public static boolean isHighQualityWelfareType(Integer type) {
        return highQualityWelfareTypes.contains(type);
    }

    /**
     * 优质线索资料类型
     */
    private static List<Integer> highQualityResourceTypes = Lists.newArrayList();

    static {
        highQualityResourceTypes.addAll(Lists.newArrayList(FREE_RESOURCE.getType(), FORM_RESOURCE.getType()));
    }

    public static List<Integer> getHighQualityResourceTypes() {
        return highQualityResourceTypes;
    }

    public static boolean isHighQualityResourceType(Integer type) {
        return highQualityResourceTypes.contains(type);
    }

    /**
     * 普通资料类型（除表单资料和免费领资料外的其他资料）
     */
    private static final List<Integer> normalResourceTypes = Lists.newArrayList();

    static {
        normalResourceTypes.addAll(Lists.newArrayList(MATERIAL.getType(), LINK_RESOURCE.getType(), OA_RESOURCE.getType()));
    }

    public static boolean isNormalResource(Integer type){
        if(NumberUtil.isNullOrLteZero(type)){
            return false;
        }
        return normalResourceTypes.contains(type);
    }

    /**
     * 优质线索互动类型
     */
    private static List<Integer> highQualityTypes = Lists.newArrayList();

    static {
        highQualityTypes.addAll(Lists.newArrayList(GRAB_WELFARE.getType(), FREE_GET.getType(), FREE_RESOURCE.getType(), FORM_RESOURCE.getType()));
    }

    public static List<Integer> getHighQualityTypes() {
        return highQualityTypes;
    }

    /**
     * 线索互动类型（中奖，免费领，以及所有资料）
     */
    private static List<Integer> clueInteractTypes = Lists.newArrayList();

    static {
        clueInteractTypes.addAll(Lists.newArrayList(GRAB_WELFARE.getType(), FREE_GET.getType(), MATERIAL.getType(), LINK_RESOURCE.getType(), OA_RESOURCE.getType(), FREE_RESOURCE.getType(), FORM_RESOURCE.getType()));
    }

    public static List<Integer> getClueInteractTypes() {
        return clueInteractTypes;
    }
}
