package cn.com.duiba.kjy.livecenter.api.param.clue;

import cn.com.duiba.kjy.livecenter.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 直播红包领取记录
 * @author kjj mybatis generator 
 * @date 2020-04-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class LiveRedPacketReceiveSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 15858340744385252L;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 红包配置ID
     */
    private Long confRedPacketId;

    /**
     * 直播访客userId
     */
    private Long liveVisitorId;

    /**
     * 代理人ID
     */
    private Long agentId;

    /**
     * 领取状态：1-未领取，2-领取中，3-领取成功，4-领取失败
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.LiveRedPacketReceiveStatusEnum
     */
    private Integer receiveStatus;

    //区别原业务的查询
    /**
     *查询福利id
     */
    private Long rewardId;

    /**
     * 开奖类型
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.LiveRedPacketReciveRewardTypeEnum
     */
    private Integer rewardType;
}