package cn.com.duiba.kjy.livecenter.api.remoteservice.wspush;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.wspush.WsComingDto;

import java.util.List;

/**
 * 用户来了消息推送队列
 * @author dugq
 * @date 2020-07-01
 */
@AdvancedFeignClient
public interface RemoteUserComingService {

    /**
     * 追加新进入直播间的用户
     * @param liveId 直播ID
     * @param userIds 直播用户ID集合
     */
    void addUser(Long liveId, List<Long> userIds);

    /**
     * 获取最近1s直播新来的用户
     * @param liveId 直播ID
     * @return 用户来了集合
     */
    List<WsComingDto> getRecentlyUser(Long liveId);
}
