package cn.com.duiba.kjy.livecenter.api.remoteservice.company;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.company.video.LiveCompanyVideoDto;
import cn.com.duiba.kjy.livecenter.api.param.company.LiveCompanyVideoSearchParam;

import java.util.List;

/**
 * @author liuchao1
 * @version 1.0
 * @date 2020-09-24 18:58
 */
@AdvancedFeignClient
public interface RemoteLiveCompanyVideoService {

    /**
     * 根据条件查询，分页
     * @param param 查询条件
     * @return 直播公司精彩视频集合
     */
    List<LiveCompanyVideoDto> selectPage(LiveCompanyVideoSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long selectCount(LiveCompanyVideoSearchParam param);

    /**
     * 保存或更新视频信息
     * @param dto 视频信息
     * @return 处理结果
     */
    boolean saveOrUpdate(LiveCompanyVideoDto dto);

    /**
     * 置顶
     * @param id 视频主键id
     * @return 处理结果
     */
    boolean top(Long id);

    /**
     * 取消置顶
     * @param id 视频主键id
     * @return 处理结果
     */
    boolean cancelTop(Long id);

    /**
     * 上移
     * @param id 视频主键id
     * @return 处理结果
     */
    boolean up(Long id);

    /**
     * 下移
     * @param id 视频主键id
     * @return 处理结果
     */
    boolean down(Long id);

    /**
     * 删除
     * @param id 视频主键id
     * @return 处理结果
     */
    boolean delete(Long id);

    /**
     * 根据主键id查询
     * @param id 主键id
     * @return 视频信息
     */
    LiveCompanyVideoDto findById(Long id);

}
