package cn.com.duiba.kjy.livecenter.api.enums.lottery;

/**
 * @author lizhi
 * @date 2020/6/4 10:29 AM
 */
public enum LiveLotteryCodeSourceEnum {

    APPOINTMENT(1,"预约"),
    SIGN_IN(2,"签到"),
    SUBSCRIBE(3,"关注直播间"),
    ACCUMULATE_READ(4,"累计观看"),
    FRIEND_INVITE(5,"邀请好友"),
    VEST(6,"马甲"),
    AUTH_PHONE(7,"授权手机号"),
    LUCK_TASK(8, "幸运任务"),
    BCM_TASK(9, "水晶蜜卡"),
    SAVE_POSTER_TASK(10, "保存海报"),
    COMPLETE_TASK(11, "完成任务"),
    ;

    /**
     * 类型
     */
    private Integer type;

    /**
     * 描述
     */
    private String desc;

    LiveLotteryCodeSourceEnum(Integer type ,String desc){
        this.type  = type;
        this.desc  = desc;
    }

    public static LiveLotteryCodeSourceEnum getByType(Integer type) {
        for (LiveLotteryCodeSourceEnum enumVal : LiveLotteryCodeSourceEnum.values()) {
            if (enumVal.getType().equals(type)) {
                return enumVal;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
