package cn.com.duiba.kjy.livecenter.api.cache;

import cn.com.duiba.wolf.utils.SecurityUtils;
import com.alibaba.fastjson.JSON;
import com.github.benmanes.caffeine.cache.Cache;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.lang.reflect.Method;

/**
 * @Author xujing
 * @Date 2020/12/28 9:56 上午
 */
@Slf4j
@Aspect
@Component
public class DuibaCacheAspect {

    @Resource
    private DuibaCacheManager duibaCacheManager;

    @Pointcut("@annotation(cn.com.duiba.kjy.livecenter.api.cache.DuibaLocalCache)")
    public void executionService() {
    }

    @Around("executionService()")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        //获取类
        Class clazz = pjp.getTarget().getClass();

        //获取代理方法对象
        Signature signature = pjp.getSignature();
        MethodSignature methodSignature = (MethodSignature) signature;
        Method method = methodSignature.getMethod();
        if (method == null) {
            log.error(("NoSuchMethod:" + clazz.getName() + ":" + signature.getName()));
            return pjp.proceed();
        }
        DuibaLocalCache duibaLocalCache = method.getAnnotation(DuibaLocalCache.class);
        String cacheName = duibaLocalCache.cacheEnum().name();
        Cache cache = duibaCacheManager.getCacheManager().get(cacheName);
        if(null==cache){
            return pjp.proceed();
        }
        Object[] args = pjp.getArgs();
        if (args == null) {
            args = new Object[0];
        }
        String cacheKey = cacheName;
        if (args.length > 0) {
            cacheKey += "_" + SecurityUtils.encode2StringByMd5(JSON.toJSONString(args) + "_" + JSON.toJSONString(method.getParameterTypes()));
        }
        return cache.get(cacheKey, res -> {
            try {
                return pjp.proceed();
            } catch (Throwable throwable) {
                log.error("缓存报错", throwable);
            }
            return null;
        });
    }
}
