package cn.com.duiba.kjy.livecenter.api.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;

/**
 * @Author xujing
 * @Date 2020/12/28 9:54 上午
 */
@Data
@Slf4j
@Component
public class DuibaCacheManager {

    private Map<String, Cache> cacheManager = new HashMap<>();

    @PostConstruct
    public void init() {

        DuibaCacheEnum[] enumConstants = DuibaCacheEnum.values();
        for (DuibaCacheEnum single : enumConstants) {
            cacheManager.computeIfAbsent(single.name(), f -> Caffeine.newBuilder().expireAfterWrite(single.getTime(), single.getTimeUnit()).maximumSize(single.getMaxSize()).build());
        }
    }
}
