package cn.com.duiba.kjy.livecenter.api.dto.guide;

import cn.com.duiba.kjy.livecenter.api.enums.guide.GuideProcessTypeEnum;
import com.alibaba.fastjson.JSON;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;

/**
 * @Author xujing
 * @Date 2020/12/5 11:21 上午
 */
@Data
public class GuideProcessDto implements Serializable {

    private static final long serialVersionUID = -37233065877887247L;

    /**
     * 流程类型
     * @see GuideProcessTypeEnum
     */
    private Integer processType;

    /**
     * 每轮停留时间 单位s
     * 当流程不止一轮时 - 分割
     * 30-60-90
     */
    private String standingTime;

    /**
     * 优先级
     * 越小越靠近前
     */
    private Integer guideProcessPriority;

    //红包配置信息 start
    /**
     * 中奖人数
     */
    private Integer redWinningNum;

    /**
     * 每人发放金额
     * 单位分
     */
    private Integer redSendAmount;

    /**
     * 中奖概率（20%）
     */
    private Double redWinningProbability;

    //红包配置信息 end

    //爆款预约配置信息 start
    /**
     * 预约数字
     * 达到多少预约结束任务
     */
    private Integer appointmentNum;

    //爆款预约配置信息 end

    public static void main(String[] args) {
        GuideProcessDto red = new GuideProcessDto();
        red.setProcessType(GuideProcessTypeEnum.RED_PACKET.getType());
        red.setStandingTime("30-60");
        red.setRedWinningNum(10);
        red.setRedSendAmount(30);
        red.setGuideProcessPriority(1);
        red.setRedWinningProbability(0.2);

        GuideProcessDto lottery = new GuideProcessDto();
        lottery.setProcessType(GuideProcessTypeEnum.LOTTERY_YARDS.getType());
        lottery.setStandingTime("30");
        lottery.setGuideProcessPriority(2);


        GuideProcessDto boom = new GuideProcessDto();
        boom.setProcessType(GuideProcessTypeEnum.BOOM_APPOINTMENT.getType());
        boom.setStandingTime("6000");
        boom.setAppointmentNum(3);
        boom.setGuideProcessPriority(3);


        List<GuideProcessDto> guideProcessDtos = Arrays.asList(red,lottery,boom);

        LiveGuideProcessDto map = new LiveGuideProcessDto();
        map.setLiveId(0L);
        map.setList(guideProcessDtos);

        ArrayList<LiveGuideProcessDto> dtos = new ArrayList<>();

        dtos.add(map);

        System.out.println(JSON.toJSONString(dtos));


    }
}
