package cn.com.duiba.kjy.livecenter.api.dto.guide;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * @Author xujing
 * @Date 2020/12/4 6:09 下午
 */
@Data
public class LiveGuideProcessRecordDto implements Serializable {

    private static final long serialVersionUID = -6347166468257905623L;
    /**
    * 主键
    */
    private Long id;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 更新时间
    */
    private Date gmtModified;

    /**
    * 直播间id
    */
    private Long liveId;

    /**
    * 用户id
    */
    private Long liveUserId;

    /**
    * 过程类型 1 红包 2 抽奖码 3预约爆款
    */
    private Integer processType;

    /**
    * 过程是否完成 0未完成 1已完成
    */
    private Integer processComplete;

    /**
    * 用户完成获得的结果 红包的话是金额 抽奖码的话是券码值
    */
    private String processResult;

    /**
    * 用户参与时间
    */
    private Date joinTime;

    /**
    * 描述
    */
    private String processDesc;
}