package cn.com.duiba.kjy.livecenter.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.user.LiveAgentExtDto;

import java.util.List;
import java.util.Map;

/**
 * 直播公司代理人扩展信息rpc服务
 *
 * @author xuzhigang
 * @date 2020/9/10 5:21 下午
 **/
@AdvancedFeignClient
public interface RemoteLiveAgentExtService {
    /**
     * 根据代理人id和配置名称查询配置值
     *
     * @param agentId  代理人id
     * @param confName 配置名称
     * @return 配置值
     */
    String selectValueByConfName(Long agentId, Integer confName);

    /**
     * 新增或更新
     *
     * @param dto 直播公司代理人扩展
     * @return 执行结果
     */
    int saveOrUpdate(LiveAgentExtDto dto);

    /**
     * 根据agentIds和配置名称查询配置值
     * @param agentIds 代理人id集合
     * @param confName 配置名称
     * @return key: agentId value: confName
     */
    Map<Long, String> selectValueMapByConfName(List<Long> agentIds, Integer confName);
}
