package cn.com.duiba.kjy.livecenter.api.remoteservice.push;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.push.LivePushManagerDto;
import cn.com.duiba.kjy.livecenter.api.param.push.LivePushManagerSearchParam;

import java.util.List;

/**
 * @author liuchao1
 * @version 1.0
 * @date 2020-07-11 13:34
 */
@AdvancedFeignClient
public interface RemoteLivePushManagerService {

    /**
     * 根据条件查询，分页
     * @param param 查询条件
     * @return 直播推送管理集合
     */
    List<LivePushManagerDto> selectPage(LivePushManagerSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long selectCount(LivePushManagerSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 直播推送管理
     */
    LivePushManagerDto selectById(Long id);

    /**
     * 新增
     * @param dto 直播推送管理
     * @return 执行结果
     */
    int insert(LivePushManagerDto dto);

    /**
     * 更新
     * @param dto 直播推送管理
     * @return 执行结果
     */
    int update(LivePushManagerDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

}
