package cn.com.duiba.kjy.livecenter.api.remoteservice.welfarerain;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.welfareRain.WelfareRainResultDto;
import cn.com.duiba.kjy.livecenter.api.dto.welfareRain.WelfareRainSimpleResultDto;
import cn.com.duiba.kjy.livecenter.api.enums.live.WelfareRainOptionTypeEnum;
import cn.com.duiba.kjy.livecenter.api.param.welfarerain.WelfareRainDrawParam;

import java.util.Set;

/**
 * @author chengsiyi
 * @date 2020/10/27 10:48
 */
@AdvancedFeignClient
public interface RemoteWelfareRainEventService {

    /**
     * 开始收集用户信息
     *
     * @param liveId 直播ID
     */
    void startCollect(Long liveId);

    /**
     * 开始计算用户
     *
     * @param liveId
     * @param confId
     */
    void compute(Long liveId, Long confId);

    /**
     * 访客抽取
     */
    WelfareRainResultDto draw(WelfareRainDrawParam drawParam);

    /**
     * 判断访客是否在指定的抽奖用户池
     * 及时判断，及时返回
     *
     * @param liveId     直播ID
     * @param confId     福利雨ID
     * @param liveUserId 用户ID
     * @return 是否在指定用户池
     */
    Boolean isSpecialUser(Long liveId, Long confId, Long liveUserId);

    /**
     * 停止领取
     *
     * @param liveId 直播ID
     * @param confId 福利雨ID
     */
    void stopReceive(Long liveId, Long confId);

    /**
     * 补充马甲
     *
     * @param liveId 直播ID
     * @param confId 福利雨ID
     */
    void addVestAndEnd(Long liveId, Long confId);

    /**
     * 获取结果
     * @param liveId 直播ID
     * @param confId 福利雨ID
     * @return
     */
    Set<WelfareRainSimpleResultDto> getWelfareRainDrawResult(Long liveId, Long confId);
}
