package cn.com.duiba.kjy.livecenter.api.util;

import cn.com.duiba.kjy.livecenter.api.dto.wspush.WsResult4PersonalDto;
import cn.com.duiba.kjy.livecenter.api.dto.wspush.WsResultDto;
import com.alibaba.fastjson.JSON;

import java.io.Serializable;

/**
 * web socket公共推送
 * 对象转json字符串工具类
 * @author lizhi
 * @date 2020/7/16 3:23 PM
 */
public class CommonPushUtils {

    private CommonPushUtils() {}

    /**
     * 单个用户-推送内容转json string
     * @param dto 单个用户推送信息
     * @return 转换后对象
     */
    public static <T extends Serializable> WsResult4PersonalDto<String> toJsonStringUser(WsResult4PersonalDto<T> dto) {
        if (dto == null) {
            return null;
        }
        WsResult4PersonalDto<String> resultDto = new WsResult4PersonalDto<>();
        resultDto.setUserId(dto.getUserId());
        resultDto.setResult(toJsonString(dto.getResult()));
        return resultDto;
    }

    /**
     * 推送内容转json string
     * @param dto 推送信息
     * @return 转换后对象
     */
    public static <T extends Serializable> WsResultDto<String> toJsonString(WsResultDto<T> dto) {
        WsResultDto<String> resultDto = new WsResultDto<>();
        resultDto.setMsgType(dto.getMsgType());
        resultDto.setData(toJsonString(dto.getData()));
        return resultDto;
    }

    private static <T extends Serializable> String toJsonString(T data) {
        if (data == null) {
            return null;
        }
        if (data instanceof String) {
            return (String) data;
        }
        return JSON.toJSONString(data);
    }
}
