package cn.com.duiba.kjy.livecenter.api.dto.agent;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
/**
 * 代理人邀约任务完成情况
 * @author sunyan
 */
@Data
public class AgentAptaskRecordDto implements Serializable {
    private static final long serialVersionUID = 2244434235090117244L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 任务id
     */
    private Long taskId;

    /**
     * 主播用户id
     */
    private Long liveVisitorId;

    /**
     * 总邀请人数
     */
    private Integer apTotal;

    /**
     * 当前任务
     */
    private Integer nowTask;

    /**
     * 是否展示任务一奖励弹层
     */
    private Boolean showReward1;

    /**
     * 是否展示任务二奖励弹层
     */
    private Boolean showReward2;

    /**
     * 任务二邀约到的人数
     */
    private Integer apTask2Num;

    /**
     * 任务一得到红包金额
     */
    private Integer reward1Amount;

    /**
     * 任务二得到红包金额
     */
    private Integer reward2Amount;

    private Boolean deleted;

    private Date gmtCreate;

    private Date gmtModified;

    /**
     * 是否展示任务三奖励弹层
     */
    private Boolean showReward3;
    /**
     * 任务三邀约到的人数
     */
    private Integer apTask3Num;
    /**
     * 任务三得到红包金额
     */
    private Integer reward3Amount;
}