package cn.com.duiba.kjy.livecenter.api.remoteservice.clue;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.clue.LiveClueChoiceQuestionDto;

import java.util.List;

/**
 * 测一测访客线索
 * @author lizhi
 * @date 2020/5/19 10:56 AM
 */
@AdvancedFeignClient
public interface RemoteLiveClueChoiceQuestionService {

    /**
     * 参与问题的记录数
     * @param choiceQuestionId 问题ID
     * @return 符合条件的记录数
     */
    long findCountByChoiceQuestionId(Long choiceQuestionId);

    /**
     * 批量新增选择题 答题线索
     * @param clueChoiceQuestionDtoList
     * @return
     */
    int batchInsert(Long liveId,List<LiveClueChoiceQuestionDto> clueChoiceQuestionDtoList);

    /**
     * 查询已经回答过的用户
     * 用户排除掉已经作答的用户的提交
     * @param liveId
     * @param questionId
     * @param liveUserIds
     * @return
     */
    List<Long> findLiveUserIdByLiveIdAndQuestionId(Long liveId,Long questionId,List<Long> liveUserIds);
}
