package cn.com.duiba.kjy.livecenter.api.remoteservice.cardLibrary;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.cardLibrary.CardCouponCountDto;
import cn.com.duiba.kjy.livecenter.api.dto.cardLibrary.CardCouponDto;
import cn.com.duiba.kjy.livecenter.api.param.cardLibrary.CardCouponImportParam;
import cn.com.duiba.kjy.livecenter.api.param.cardLibrary.CardCouponPageQuery;
import cn.com.duiba.kjy.livecenter.api.param.cardLibrary.CountCardCouponParam;

import java.util.List;

/**
 * @Author xujing
 * @Date 2021/3/3 10:06 上午
 */
@AdvancedFeignClient
public interface RemoteCardCouponService {

    /**
     * 批量导入并且更新库存
     *
     * @param cardCouponImportParam
     * @return
     */
    Integer batchImportingAndUpdateStock(CardCouponImportParam cardCouponImportParam);

    /**
     * 根据卡券库ids 和卡券状态查询数量
     *
     * @param countCardCouponParam
     * @return
     */
    List<CardCouponCountDto> countByCardLibraryIdAndStatus(CountCardCouponParam countCardCouponParam);

    /**
     * 根据批次id
     * 卡券，卡券状态
     * 查询卡券数量
     *
     * @param cardCouponPageQuery
     * @return
     */
    Long countByParam(CardCouponPageQuery cardCouponPageQuery);

    /**
     * 根据批次id
     * 卡券，卡券状态
     * 查询卡券列表
     *
     * @param cardCouponPageQuery
     * @return
     */
    List<CardCouponDto> pageByParam(CardCouponPageQuery cardCouponPageQuery);


    /**
     * 根据id查询卡券
     *
     * @param id
     * @return
     */
    CardCouponDto findById(Long id);


    /**
     * 删除卡券并且更新批次库存
     *
     * @param id
     * @return
     */
    Integer deleteByIdAndDecreaseStock(Long id);

    /**
     * 根据领取id和用户id查询已发放卡券
     */
    CardCouponDto selectIssuedByRecordAndUser(Long userId,Long recordId);
}
