package cn.com.duiba.kjy.livecenter.api.enums.task;

import cn.com.duiba.kjy.livecenter.api.enums.live.WsMsgTypeEnum;
import cn.com.duiba.live.activity.center.api.enums.lottery.LiveLotteryCodeSourceEnum;

/**
 * @Author xujing
 * @Date 2020/11/10 4:30 下午
 * 前端显示
 * 抽奖券类型
 * socket类型枚举
 */
public enum TaskWebTypeEnum {
    SAVE_POSTERS("prepostshare", "保存海报", LiveLotteryCodeSourceEnum.SAVE_POSTER_TASK, WsMsgTypeEnum.DUIBA_LIVE_SAVE_POSTERS),
    FILL_IN_QUESTIONNAIRE("questionnaire", "填写问卷", LiveLotteryCodeSourceEnum.FILL_IN_QUESTIONNAIRE, WsMsgTypeEnum.DUIBA_LIVE_FILL_IN_QUESTIONNAIRE),
    DEFAULT("default", "默认的任务成功类型", LiveLotteryCodeSourceEnum.COMPLETE_TASK, WsMsgTypeEnum.DUIBA_LIVE_COMPLETE_TASK);
    /**
     * 类型
     */
    private String type;

    /**
     * 描述
     */
    private String desc;

    /**
     * 文字提示枚举
     */
    private LiveLotteryCodeSourceEnum liveLotteryCodeSourceEnum;

    /**
     * socket 枚举
     */
    private WsMsgTypeEnum wsMsgTypeEnum;

    TaskWebTypeEnum(String type, String desc, LiveLotteryCodeSourceEnum liveLotteryCodeSourceEnum, WsMsgTypeEnum wsMsgTypeEnum) {
        this.type = type;
        this.desc = desc;
        this.liveLotteryCodeSourceEnum = liveLotteryCodeSourceEnum;
        this.wsMsgTypeEnum = wsMsgTypeEnum;
    }


    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public LiveLotteryCodeSourceEnum getLiveLotteryCodeSourceEnum() {
        return liveLotteryCodeSourceEnum;
    }

    public WsMsgTypeEnum getWsMsgTypeEnum() {
        return wsMsgTypeEnum;
    }

    public static TaskWebTypeEnum getInstance(String type) {
        for (TaskWebTypeEnum taskType : TaskWebTypeEnum.values()) {
            if (taskType.getType().equals(type)) {
                return taskType;
            }
        }
        return TaskWebTypeEnum.DEFAULT;
    }
}
