/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.livecenter.api.exception;

import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixCommand;
import cn.com.duiba.boot.netflix.feign.hystrix.HystrixDisabled;
import cn.com.duiba.kjy.livecenter.api.exception.BizException;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.DuibaFeignProperties;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.hystrix.FeignClientException;
import cn.com.duibaboot.ext.autoconfigure.core.rpc.RpcContext;
import cn.com.duibaboot.ext.autoconfigure.limiter.RateLimiterException;
import com.alibaba.fastjson.JSONObject;
import com.netflix.hystrix.exception.HystrixBadRequestException;
import feign.FeignException;
import feign.Response;
import feign.Util;
import feign.codec.ErrorDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeignErrorDecoderCustom
implements ErrorDecoder {
    private static final Logger logger = LoggerFactory.getLogger(FeignErrorDecoderCustom.class);
    private final ErrorDecoder.Default defaultErrorDecoder = new ErrorDecoder.Default();

    public Exception decode(String methodKey, Response response) {
        Exception exception;
        try {
            exception = this.decodeInner(methodKey, response);
        }
        catch (IOException ignored) {
            exception = this.genFeignException(response.status(), methodKey, null);
        }
        if (exception instanceof FeignException) {
            return this.defaultErrorDecoder.decode(methodKey, response);
        }
        return exception;
    }

    private Exception decodeInner(String methodKey, Response response) throws IOException {
        Object exception;
        if (response.body() != null) {
            JSONObject body = this.getBodyString(response);
            String exceptionClassStr = body.getString("exception");
            Class exceptionClass = this.tryGetExceptionClass(exceptionClassStr);
            if (exceptionClass != null) {
                exception = cn.com.duiba.boot.exception.BizException.class.isAssignableFrom(exceptionClass) ? new BizException(body.getString("message")).withCode(body.getString("code")) : (BizException.class.isAssignableFrom(exceptionClass) ? new BizException(body.getString("message")).withCode(body.getString("code")) : (RateLimiterException.class.isAssignableFrom(exceptionClass) ? new RateLimiterException() : this.genFeignException(response.status(), methodKey, body.toJSONString())));
                if (IllegalArgumentException.class.isAssignableFrom(exceptionClass) || exceptionClass.isAnnotationPresent(HystrixDisabled.class) || this.isInMethodIgnoreExceptions(RpcContext.getContext().getMethod(), exceptionClass)) {
                    exception = new HystrixBadRequestException(((Throwable)exception).getMessage(), (Throwable)exception);
                } else if (RejectedExecutionException.class.isAssignableFrom(exceptionClass)) {
                    // empty if block
                }
            } else {
                exception = this.genFeignException(response.status(), methodKey, body.toJSONString());
            }
        } else {
            exception = this.genFeignException(response.status(), methodKey, null);
        }
        return exception;
    }

    private Class tryGetExceptionClass(String exceptionClassStr) {
        Class<?> exceptionClass = null;
        if (exceptionClassStr != null) {
            try {
                exceptionClass = Class.forName(exceptionClassStr);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return exceptionClass;
    }

    private JSONObject getBodyString(Response response) throws IOException {
        byte[] bs;
        Object obj;
        DuibaFeignProperties.DuibaFeignSerialization stype;
        String contentType = null;
        Collection coll = (Collection)response.headers().get("Content-Type".toLowerCase());
        if (coll != null && !coll.isEmpty()) {
            contentType = (String)coll.iterator().next();
        }
        JSONObject body = (stype = DuibaFeignProperties.DuibaFeignSerialization.contentTypeOf(contentType)) == null || stype == DuibaFeignProperties.DuibaFeignSerialization.JSON ? JSONObject.parseObject((String)Util.toString((Reader)response.body().asReader())) : ((obj = stype.deserialize(bs = IOUtils.toByteArray((InputStream)response.body().asInputStream()))) instanceof String ? JSONObject.parseObject((String)((String)obj)) : (JSONObject)JSONObject.toJSON((Object)obj));
        return body;
    }

    private boolean isInMethodIgnoreExceptions(Method method, Class exceptionClass) {
        FeignHystrixCommand commandOfMethod = method.getAnnotation(FeignHystrixCommand.class);
        FeignHystrixCommand commandOfClass = method.getDeclaringClass().getAnnotation(FeignHystrixCommand.class);
        return this.isInIgnoreExceptions(commandOfMethod, exceptionClass) || this.isInIgnoreExceptions(commandOfClass, exceptionClass);
    }

    private boolean isInIgnoreExceptions(FeignHystrixCommand command, Class exceptionClass) {
        Class[] classes;
        if (command != null && (classes = command.ignoreExceptions()) != null) {
            for (Class clazz : classes) {
                if (!clazz.isAssignableFrom(exceptionClass)) continue;
                return true;
            }
        }
        return false;
    }

    private <T> T firstOrNull(Map<String, Collection<T>> map, String key) {
        if (map.containsKey(key) && !map.get(key).isEmpty()) {
            return map.get(key).iterator().next();
        }
        return null;
    }

    private FeignClientException genFeignException(int status, String methodKey, String responseBody) {
        StringBuilder sb = new StringBuilder();
        if (RpcContext.hasContext()) {
            RpcContext rc = RpcContext.getContext();
            sb.append("(").append(rc.getLocalAddr()).append(" -> ").append(rc.getRemoteAddr()).append(")");
        }
        sb.append(String.format("status %s reading %s", status, methodKey));
        sb.append("; content:\n").append(responseBody);
        return new FeignClientException(status, sb.toString());
    }

    static class RetryAfterDecoder {
        static final DateFormat RFC822_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        private final DateFormat rfc822Format;

        RetryAfterDecoder() {
            this(RFC822_FORMAT);
        }

        RetryAfterDecoder(DateFormat rfc822Format) {
            this.rfc822Format = (DateFormat)Util.checkNotNull((Object)rfc822Format, (String)"rfc822Format", (Object[])new Object[0]);
        }

        protected long currentTimeMillis() {
            return System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Date apply(String retryAfter) {
            if (retryAfter == null) {
                return null;
            }
            if (retryAfter.matches("^[0-9]+$")) {
                long deltaMillis = TimeUnit.SECONDS.toMillis(Long.parseLong(retryAfter));
                return new Date(this.currentTimeMillis() + deltaMillis);
            }
            DateFormat dateFormat = this.rfc822Format;
            synchronized (dateFormat) {
                try {
                    return this.rfc822Format.parse(retryAfter);
                }
                catch (ParseException ignored) {
                    return null;
                }
            }
        }
    }
}

