package cn.com.duiba.kjy.livecenter.api.enums.company;

import java.util.HashMap;
import java.util.Map;

/**
 * @author chengsiyi
 * @date 2021/2/5 15:19
 */
public enum AuthMpTypeEnum {

    /**
     * 授权小程序类型
     */
    VISITOR(1,"访客端"),
    MANAGE(2, "管理端");

    Integer mpType;

    String desc;

    AuthMpTypeEnum(Integer mpType, String desc) {
        this.mpType = mpType;
        this.desc = desc;
    }

    private static final Map<Integer, AuthMpTypeEnum> ENUM_MAP = new HashMap<>();

    static {
        for (AuthMpTypeEnum tmp : values()) {
            ENUM_MAP.put(tmp.getMpType(), tmp);
        }
    }

    public static AuthMpTypeEnum getByType(Integer code) {
        return ENUM_MAP.get(code);
    }

    public Integer getMpType() {
        return mpType;
    }

    public String getDesc() {
        return desc;
    }
}
