package cn.com.duiba.kjy.livecenter.api.dto.wspush.advice;

import cn.com.duiba.kjy.livecenter.api.util.IdFastJsonSerializable;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播聊天室-web socket推送-消息
 * @author lizhi
 * @date 2020/7/2 7:22 PM
 */
@Data
public class WsAdviceSendDto implements Serializable {

    private static final long serialVersionUID = -4729948600598835927L;

    /**
     * 消息主键
     */
    @JSONField(serializeUsing = IdFastJsonSerializable.class)
    private Long id;

    /**
     * 会话ID
     */
    private String sessionId;

    /**
     * 聊天消息文本
     */
    private String msgText;

    /**
     * 回复类型 0：访客回复 1：代理人回复 2:代理人自动回复
     * @see cn.com.duiba.kjy.livecenter.api.enums.advice.AdviceChatTypeEnum
     */
    private Integer chatType;

    /**
     * 创建时间
     */
    private Date gmtCreate;

}
