package cn.com.duiba.kjy.livecenter.api.remoteservice.live;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.live.LiveBoomGoodsDto;

import java.util.List;

/**
 * @author chengsiyi
 * @date 2021/5/17 10:41
 */
@AdvancedFeignClient
public interface RemoteLiveBoomGoodsService {

    /**
     * 保存爆款商品
     * @param liveId 直播ID
     * @param goods 商品信息
     * @return
     */
    int saveGoods(Long liveId, List<LiveBoomGoodsDto> goods);

    int updateById(LiveBoomGoodsDto dto);

    LiveBoomGoodsDto getById(Long id);

    /**
     * 获取直播间爆款商品
     * @param liveId 直播间ID
     * @return 商品
     */
    List<LiveBoomGoodsDto> getByLiveId(Long liveId);
}
