package cn.com.duiba.kjy.livecenter.api.enums.goods;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * @author chengsiyi
 * @date 2021/6/23 15:49
 */
public enum GoodsMarketTypeEnum {

    /**
     * 商品营销类型
     */
    NORMAL(1, "普通商品"),
    HALF_PRICE(2, "半价商品"),
    ACTIVITY_FREE(3, "免费抢"),
    HALF_PRICE_DRAW(4, "半价抽"),
    ;

    Integer marketType;

    String desc;

    GoodsMarketTypeEnum(Integer marketType, String desc) {
        this.marketType = marketType;
        this.desc = desc;
    }

    private static final Map<Integer, GoodsMarketTypeEnum> ENUM_MAP = new HashMap<>();
    /**
     * 抽奖用
     */
    private static final Set<Integer> LOTTERY_TYPE = new HashSet<>();

    static {
        for (GoodsMarketTypeEnum tmp : values()) {
            ENUM_MAP.put(tmp.getMarketType(), tmp);
        }
        LOTTERY_TYPE.add(ACTIVITY_FREE.getMarketType());
        LOTTERY_TYPE.add(HALF_PRICE_DRAW.getMarketType());
    }

    public static GoodsMarketTypeEnum of(Integer code) {
        return ENUM_MAP.get(code);
    }

    public Integer getMarketType() {
        return marketType;
    }

    public String getDesc() {
        return desc;
    }

    public static Set<Integer> getLotteryMarket (){
        return LOTTERY_TYPE;
    }
}
