package cn.com.duiba.kjy.livecenter.api.param.liveInteract;

import cn.com.duiba.kjy.livecenter.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 直播互动配置关联表
 * @author kjj mybatis generator 
 * @date 2020-04-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class LiveInteractConfSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 1585810605304699L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 互动id
     */
    private Long interactId;

    /**
     * 互动类型：1-资料，2-问题, 3-关注直播间，4-累计观看，5-邀请好友，6-免费领，7-抢权益
     */
    private Integer interactType;

    /**
     * 权益数量，-1为不限制数量
     */
    private Integer interactNum;

    /**
     * 开抢时间
     */
    private Date startTime;

    /**
     * 互动状态，1-未启用，2-已上架，3-已下架
     */
    private Byte interactStatus;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}