package cn.com.duiba.kjy.livecenter.api.remoteservice.live.share;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.share.LiveShareConfDto;

import java.util.List;

/**
 * 直播分享配置rpc服务
 *
 * @author xuzhigang
 * @date 2020/8/8 3:48 下午
 **/
@AdvancedFeignClient
public interface RemoteLiveShareConfService {
    /**
     * 根据直播ID和分享类型查询分享配置
     *
     * @param liveId 直播ID
     * @param shareType 分享类型
     * @return 直播分享配置集合
     */
    List<LiveShareConfDto> selectListByLiveIdAndShareType(Long liveId, Integer shareType);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 直播分享配置
     */
    LiveShareConfDto selectById(Long id);

    /**
     * 新增/编辑分享配置
     *
     * @param dto 分享配置信息
     * @return true-成功 false-失败
     */
    boolean saveOrUpdate(LiveShareConfDto dto);

    /**
     * 逻辑删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 分享数自增
     * @param id 主键
     * @return 执行结果
     */
    int incrClickNum(Long id,Long userId);

    /**
     * 根据直播ID和分享类型查询分享配置
     *
     * @param liveId 直播ID
     * @param shareType 分享类型
     * @param whetherDisable 是否禁用
     * @return 直播分享配置集合
     */
    List<LiveShareConfDto> selectListByLiveIdAndShareTypeAndDisable(Long liveId, Integer shareType, Integer whetherDisable);
}
