package cn.com.duiba.kjy.livecenter.api.enums.conf;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @Author xujing
 * @Date 2021/6/25 5:03 下午
 */
@Getter
public enum  ApplyCardTypeEnum {
    LIVE_PRE_COMMODITY_LIST(1,"直播前商品清单"),
    LIVE_ING_COMMODITY_LIST(2,"直播中商品清单"),
    LIVE_ING_ASIDE_SHOP_CART(3,"直播中购物车旁"),
    ;


    private Integer type;

    private String desc;

    ApplyCardTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, ApplyCardTypeEnum> ENUM_MAP = new HashMap<>();


    static {
        for (ApplyCardTypeEnum applyCardTypeEnum : values()) {
            ENUM_MAP.put(applyCardTypeEnum.getType(), applyCardTypeEnum);
        }
    }

    public static ApplyCardTypeEnum getByType(Integer key) {
        if (key == null) {
            return null;
        }
        return ENUM_MAP.get(key);
    }

    /**
     * 是否包含
     *
     * @param key
     * @return
     */
    public static boolean contains(Integer key) {
        if (null == key) {
            return false;
        }
        for (ApplyCardTypeEnum enumVal : ApplyCardTypeEnum.values()) {
            if (Objects.equals(enumVal.getType(), key)) {
                return true;
            }
        }
        return false;
    }
}
