package cn.com.duiba.kjy.livecenter.api.remoteservice.credits;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.credits.CreditsOrderNotifyDto;
import cn.com.duiba.kjy.livecenter.api.dto.credits.CreditsOrderRecordDto;

import java.util.List;

/**
 * @author chengsiyi
 * @date 2021/8/12 11:22
 */
@AdvancedFeignClient
public interface RemoteCreditsOrderNotifyService {

    /**
     * 接受积分商城订单推送
     * @param order 订单信息
     * @return
     */
    boolean notifyOrder(CreditsOrderNotifyDto order);

    /**
     * 获取购买记录
     * @param liveUserId not null 用户ID
     * @param recordItemId null 商品ID
     * @param itemType null 商品类型 1-实物，2-优惠券
     * @return 购买记录
     */
    List<CreditsOrderRecordDto> getUserRecord(Long liveUserId, Long recordItemId, Integer itemType);

}
