package cn.com.duiba.kjy.livecenter.api.enums.conf;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @Author xujing
 * @Date 2021/6/25 5:03 下午
 */
@Getter
public enum ApplyCardWayEnum {
    H5(1, "h5"),
    APPLETS(2, "小程序"),
    ;


    private Integer way;

    private String desc;

    ApplyCardWayEnum(Integer way, String desc) {
        this.way = way;
        this.desc = desc;
    }

    private static final Map<Integer, ApplyCardWayEnum> ENUM_MAP = new HashMap<>();


    static {
        for (ApplyCardWayEnum cardWayEnum : values()) {
            ENUM_MAP.put(cardWayEnum.getWay(), cardWayEnum);
        }
    }

    public static ApplyCardWayEnum getByType(Integer key) {
        if (key == null) {
            return null;
        }
        return ENUM_MAP.get(key);
    }

    /**
     * 是否包含
     *
     * @param key
     * @return
     */
    public static boolean contains(Integer key) {
        if (null == key) {
            return false;
        }
        for (ApplyCardWayEnum enumVal : ApplyCardWayEnum.values()) {
            if (Objects.equals(enumVal.getWay(), key)) {
                return true;
            }
        }
        return false;
    }
}
