package cn.com.duiba.kjy.livecenter.api.remoteservice.conf;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.conf.ApplyCardConfigDto;
import cn.com.duiba.kjy.livecenter.api.enums.conf.ApplyCardTypeEnum;

/**
 * @Author xujing
 * @Date 2021/6/25 4:31 下午
 */
@AdvancedFeignClient
public interface RemoteApplyCardConfigService {

    /**
     * 插入一条数据
     * @param record
     * @return
     */
    Long insert(ApplyCardConfigDto record);

    /**
     * 根据id查询
     * @param id
     * @return
     */
    ApplyCardConfigDto findById(Long id);

    /**
     * 根据直播间id和类型查询
     * @param liveId
     * @param applyCardTypeEnum
     * @return
     */
    ApplyCardConfigDto findByLiveIdAndApplyCardType(Long liveId, ApplyCardTypeEnum applyCardTypeEnum);

    /**
     * 更新
     * @param updated
     * @return
     */
    int updateById(ApplyCardConfigDto updated);

    /**
     * 删除
     * @param id
     * @return
     */
    int deleteById(Long id);

}

