package cn.com.duiba.kjy.livecenter.api.dto.conf;

import cn.com.duiba.kjy.livecenter.api.enums.conf.ResourceLocationConfTypeEnum;
import cn.com.duiba.kjy.livecenter.api.enums.conf.ResourceLocationJumpPageEnum;
import cn.com.duiba.kjy.livecenter.api.enums.conf.ResourceLocationJumpWayEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 落地页配置
 * @Author xujing
 * @Date 2021/9/1 4:10 下午
 */
@Data
public class ResourceLocationConfDto implements Serializable {

    private static final long serialVersionUID = -4995522280030408483L;
    /**
    * 主键
    */
    private Long id;

    /**
    * 直播间id
    */
    private Long liveId;

    /**
     * @see ResourceLocationConfTypeEnum
    * 资源位类型，1预约页
    */
    private Integer confType;

    /**
     * @see ResourceLocationJumpWayEnum
     * 跳转方式:1 内部跳转 2 外部跳转
    */
    private Integer jumpWay;

    /**
     * @see ResourceLocationJumpPageEnum
    * 内部跳转页面:1.福利页
    */
    private Integer jumpPage;

    /**
    * 外部跳转 url
    */
    private String jumpUrl;

    /**
     * 资源位置描述
     */
    private String resourceLocation;

    /**
     * 资源图片
     */
    private String resourceImage;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModify;
}