package cn.com.duiba.kjy.livecenter.api.dto.invitation;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播访客邀请关系
 * @author kjj mybatis generator
 * @date 2020-03-28
 */
@Data
public class LiveVisitorInvitationDto implements Serializable {

    private static final long serialVersionUID = 15853608938004357L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 邀请人直播用户ID
     */
    private Long inviterId;

    /**
     * 直播访客userId
     */
    private Long liveVisitorId;

    /**
     * 邀请链路，以英文逗号分隔
     */
    private String inviterIds;

    /**
     * 用户邀请渠道
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.LiveInviteChannelEnum
     */
    private Integer inviteChannel;

    /**
     * 邀请子渠道
     */
    private String subChannel;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}
