package cn.com.duiba.kjy.livecenter.api.enums.live;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2021/6/7.
 */
@Getter
public enum BoomGoodsTypeEnum {

    DRAW(1, "DRAW", "抽奖商品"),
    NO_DRAW(2, "NO_DRAW", "不参与抽奖商品");

    private final Integer code;

    private final String  type;

    private final String  desc;

    BoomGoodsTypeEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static BoomGoodsTypeEnum getByCode(Integer code) {
        return Stream.of(BoomGoodsTypeEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(DRAW);
    }

    public static BoomGoodsTypeEnum getByType(String type) {
        return Stream.of(BoomGoodsTypeEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(DRAW);
    }
}
