package cn.com.duiba.kjy.livecenter.api.dto.smallshop.order;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;

/**
 * @Author: fss
 * @Date: 2021/9/7 15
 * @Description:
 */
@Data
public class BuyerInfoDto implements Serializable {

    private static final long serialVersionUID = -8142150270458389626L;

    /**
     * 买家ID
     */
    @JSONField(name = "buyer_id")
    private String buyerId;

    /**
     * 收货人的街道
     */
    @JSONField(name = "self_address")
    private String selfAddress;


    /**
     * 收货人所在市
     */
    @JSONField(name = "city")
    private String city;

    /**
     * 买家姓名
     */
    @JSONField(name = "name")
    private String name;

    /**
     * 收货人所在地      由于部分历史地址用户没有填入省、市、区信息，如果取不到province、region、self_address信息，请拿此字段兜底
     */
    @JSONField(name = "address")
    private String address;

    /**
     * 省份
     */
    @JSONField(name = "province")
    private String province;

    /**
     * 身份证号
     */
    @JSONField(name = "idCardNo")
    private String idCardNo;

    /**
     * 身份姓名
     */
    @JSONField(name = "idCardName")
    private String idCardName;

    /**
     * 收货人所在区
     */
    @JSONField(name = "region")
    private String region;


    /**
     * 收货人电话
     */
    @JSONField(name = "phone")
    private String phone;


    /**
     * 邮政编码
     */
    @JSONField(name = "post")
    private String post;


    /**
     * 自提订单，自提点名称
     */
    @JSONField(name = "self_shop_name")
    private String selfShopName;

}
