package cn.com.duiba.kjy.livecenter.api.util;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Created by dugq on 2020-06-03.
 */
@Slf4j
public class LotteryCodeUtil {
    //25进值对照表
    private static final Character[] PLACEHOLDERS = new Character[]{'M', 'F', 'T', 'A', 'S', 'X', 'D', 'P', 'C', 'I', 'Y', 'V', 'N', 'L', 'J', 'Q', 'E', 'U', 'Z', 'K', 'R', 'B', 'H', 'O', 'W', 'G'};

    private static final List<Character> list = new ArrayList<>(Arrays.asList(PLACEHOLDERS));

    /**
     * 私有化
     */
    private LotteryCodeUtil(){ }

    //数字位最大值
    private static final int SPLIT_LINE = 10000 / 3;

    //字符数组最大下标
    private static final int CHAR_INDEX = 25;

    //字母+数字位组成的最大值
    private static final int MAX_VALUE = CHAR_INDEX * CHAR_INDEX * CHAR_INDEX * SPLIT_LINE;


    /**
     * 加密数字 ： 最大值：52078125 超过了从1重新开始
     * 加密算法：
     * 0、加密串的整体格式为： ${firstChar} + ${lowNumber} + ${second third char} + ${random}
     * 1、把数字按照 {@link LotteryCodeUtil#SPLIT_LINE } 为 切割线，分为高位和地位。
     * 2、把高位按照 {@link LotteryCodeUtil#PLACEHOLDERS } 转化为25进值的三个字符，把第一个字符作为加密串的第一个字符(firstChar)，后两个作为中间分割字符(second third char)
     * 3、把地位数字按照*3 进行离散，用0补充为5位字符串，放在中间位置 (lowNumber)
     * 4、把地位数字 按照椭圆算法公式计算后，截取最后三位 作为随机数，补充到末尾 (random)
     * @param value
     * @return
     */
    public static String encodeNumberAs10String(long value){
        int cValue = getCValue(value);

        //用数字位记录的值 地位
        int numberValue = cValue % SPLIT_LINE;

        //用字母位记录的值。 用3位 25进制字符串 表示高位
        int characterValue = cValue / SPLIT_LINE;

        String randomString = getRandomString(cValue);

        //离散一下数字位
        numberValue = numberValue * 3;


        //最低位字符
        char thirdChar = PLACEHOLDERS[characterValue % CHAR_INDEX];

        //去掉最低位后剩余的值
        characterValue = characterValue / CHAR_INDEX;

        //中间位字符
        char secondChar = PLACEHOLDERS[characterValue % CHAR_INDEX];

        //第一位字符
        char firstChar = PLACEHOLDERS[characterValue / CHAR_INDEX];


        return "" + thirdChar + StringUtils.leftPad(String.valueOf(numberValue),5,'0') + secondChar+firstChar+ randomString ;
    }

    private static String getRandomString(int cValue) {
        //用value的最后2位计算出一个3位数的随机值
        int last1 = cValue % 100;
        if (last1 == 0){
            return "007";
        }
        int randomNum = last1 * last1 + last1 * 111 + 7;
        randomNum = randomNum % 1000;
        return StringUtils.leftPad(String.valueOf(randomNum),3,'0');
    }

    private static int getCValue(long value) {
        int cValue;
        if (value > MAX_VALUE){
            cValue = (int)(value % MAX_VALUE);
        }else{
            cValue = (int) value;
        }
        return cValue;
    }

    public static int decode10StringAsNumber(String source){
        char c1 = source.charAt(0);
        char c2 = source.charAt(6);
        char c3 = source.charAt(7);
        int i = list.indexOf(c3) * CHAR_INDEX * CHAR_INDEX + list.indexOf(c2) * CHAR_INDEX + list.indexOf(c1);
        int i1 = i * SPLIT_LINE;
        String substring = source.substring(1, 6);
        int i3 = (Integer.valueOf(substring)) / 3;
        return i1 + i3;
    }

    public static void main(String[] args) {
        test2();
        System.out.println(MAX_VALUE);
        test1();
    }

    private static void test2() {
        String source = encodeNumberAs10String(83325);
        System.out.println(source);
        System.out.println(decode10StringAsNumber(source));
    }


    private static void test1() {
        int index = 50000000;
        for (int i = index; i< 10000000+index ; i++){
            String source = encodeNumberAs10String(i);
            System.out.println(source);
            if (decode10StringAsNumber(source) != i){
                System.out.println("error = "+i);
                return;
            }
        }
    }
}
