package cn.com.duiba.kjy.livecenter.api.dto.creditCard;

import cn.com.duiba.kjy.livecenter.api.enums.creditCard.ApplyCardSourceEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 信用卡申请订单
 *
 * @Author xujing
 * @Date 2021/7/12 3:13 下午
 */
@Data
public class CreditCardApplyOrderDto implements Serializable {

    private static final long serialVersionUID = 5578243463391997325L;
    private Long id;

    /**
     * 公司id
     */
    private Long companyId;

    /**
     * 链接id
     */
    private Long cardConfId;

    /**
     * 直播间id
     */
    private Long liveId;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 手机号 冗余
     */
    private String userMobile;

    /**
     * 订单编号,唯一
     */
    private String orderNum;

    /**
     * 进件状态
     */
    private Integer applyStatus;

    /**
     * 进件时间
     */
    private Date applyTime;

    /**
     * 进件来源
     * @see ApplyCardSourceEnum
     */
    private String applySource;

    /**
     * 扩展字段
     */
    private String extInfo;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}