package cn.com.duiba.kjy.livecenter.api.remoteservice.company;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.company.video.LiveCompanyVideoStatsDto;

import java.util.List;
import java.util.Set;

/**
 * @author liuchao1
 * @version 1.0
 * @date 2020-09-25 18:04
 */
@AdvancedFeignClient
public interface RemoteLiveCompanyVideoStatsService {

    /**
     * 根据视频id查询
     * @param videoId 视频id
     * @return 视频统计信息
     */
    LiveCompanyVideoStatsDto findByVideoId(Long videoId);

    /**
     * 根据视频id集合查询
     * @param videoIds 视频id集合
     * @return 视频统计信息
     */
    List<LiveCompanyVideoStatsDto> findByVideoIds(Set<Long> videoIds);

    /**
     * 批量更新数据
     * @param dtoList 视频信息
     * @return 执行结果
     */
    int batchAddWatchNumAndShareNum(List<LiveCompanyVideoStatsDto> dtoList);

    /**
     * 点赞
     * @param videoId 视频id
     * @param liveVisitorId 直播用户id
     * @return 业务处理结果
     */
    boolean like(Long videoId, Long liveVisitorId);

    /**
     * 取消点赞
     * @param videoId 视频id
     * @param liveVisitorId 直播用户id
     * @return 业务处理结果
     */
    boolean cancelLike(Long videoId, Long liveVisitorId);
}
