package cn.com.duiba.kjy.livecenter.api.remoteservice.live;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.live.AppointmentGoodsDto;
import cn.com.duiba.kjy.livecenter.api.dto.live.AppointmentGoodsListDto;

import java.util.List;
import java.util.Map;

/**
 * Created by hong
 * time 2021/6/2.
 */
@AdvancedFeignClient
public interface RemoteLiveAppointmentGoods {
    /**
     * 获取预约商品
     * @return
     */
    AppointmentGoodsListDto getAppointmentGoods(Long liveId, Long goodsId, Long userId);

    /**
     * 获取没参与抽奖的预约商品 按照直播间分组
     * @return
     */
    Map<Long,List<AppointmentGoodsDto>> getAppointmentNoDrawGoods(List<Long> liveIds, Long goodsId, Long userId);

    /**
     * 锁定半价名额
     * @return
     */
    Boolean lockedHalfPriceQuota(Long liveId,Long goodsId,Long userId);

    /**
     * 批量获取用户预约的商品，目前只支持资料类型
     * @param liveId 直播ID
     * @param userIds 用户id
     * @return 用户预约商品ID
     */
    Map<Long, Long> getUserAppointmentGoods(Long liveId, List<Long> userIds);

    /**
     * 物理删除
     * @param id 唯一id
     * @return Integer
     */
    Integer delete(Long liveId, Long goodsId,List<Long> userIds);
}
