package cn.com.duiba.kjy.livecenter.api.dto.cardLibrary;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 卡券
 * @Author xujing
 * @Date 2021/3/3 7:19 下午
 */
@Data
public class CardCouponDto implements Serializable {

    private static final long serialVersionUID = 8837051972342974548L;
    /**
    * 主键
    */
    private Long id;

    /**
    * 卡券库id
    */
    private Long cardLibraryId;

    /**
    * 卡券库批次id
    */
    private Long cardLibraryBatchId;

    /**
    * 卡券类型
    */
    private Integer cardType;

    /**
    * 卡券
    */
    private String cardCoupon;

    /**
    * 类型是卡密时的密码
    */
    private String cardPassword;

    /**
    * 0:未发放, 1:已发放, 2:已使用
    */
    private Integer cardStatus;

    /**
    * 用户ID
    */
    private Long userId;

    /**
    * 发放记录id
    */
    private Long recordId;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

    /**
    * 扩展字段
    */
    private String customJson;

    /**
     * 直播间id
     */
    private Long liveId;

    /**
     * 直播间名称
     */
    private String liveName;

    /**
     * 发放时间
     */
    private Date sendTime;
}