package cn.com.duiba.kjy.livecenter.api.remoteservice.form;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.form.FormRecordDto;
import cn.com.duiba.kjy.livecenter.api.param.form.FormRecordSearchParam;

import java.util.List;

/**
 * 表单记录rpc服务
 *
 * @author xuzhigang
 * @date 2020/7/27 7:06 下午
 **/
@AdvancedFeignClient
public interface RemoteFormRecordService {
    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return 单提交记录集合
     */
    List<FormRecordDto> selectList(FormRecordSearchParam param);

    /**
     * 根据clueRewardId查询表单记录
     *
     * @param clueRewardId 线索奖励领取id （tb_live_clue_reward.id）
     * @return 表单记录集合
     */
    List<FormRecordDto> selectListByClueRewardId(Long clueRewardId);

    /**
     * 根据clueRewardIds查询表单记录
     *
     * @param clueRewardIds 线索奖励领取id集合 （tb_live_clue_reward.id）
     * @return 表单记录集合
     */
    List<FormRecordDto> selectListByClueRewardIds(List<Long> clueRewardIds);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(FormRecordSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 单提交记录
     */
    FormRecordDto selectById(Long id);

    /**
     * 新增
     * @param dto 单提交记录
     * @return 执行结果
     */
    int insert(FormRecordDto dto);

    /**
     * 批量insert
     *
     * @param list 表单记录集合
     * @return 执行结果
     */
    int batchInsertGeneratedKeys(List<FormRecordDto> list);

    /**
     * 更新
     * @param dto 单提交记录
     * @return 执行结果
     */
    int update(FormRecordDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}
