package cn.com.duiba.kjy.livecenter.api.remoteservice.security;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.security.SensitiveWordsDto;
import cn.com.duiba.kjy.livecenter.api.param.security.SensitiveWordsPageParam;

import java.util.List;

/**
 * 敏感词
 *
 * @Author xujing
 * @Date 2021/3/22 5:27 下午
 */
@AdvancedFeignClient
public interface RemoteSensitiveWordsService {

    /**
     * 根据主键删除
     *
     * @param id
     * @return
     */
    int deleteById(Long id);

    /**
     * 批量插入
     *
     * @param record
     * @return
     */
    Integer insertList(List<SensitiveWordsDto> record);

    /**
     * 查询
     *
     * @param id
     * @return
     */
    SensitiveWordsDto selectById(Long id);

    /**
     * 更新
     *
     * @param record
     * @return
     */
    int updateById(SensitiveWordsDto record);

    /**
     * 查询列表
     *
     * @param pageParam
     * @return
     */
    List<SensitiveWordsDto> listByParam(SensitiveWordsPageParam pageParam);

    /**
     * 查询count
     *
     * @param pageParam
     * @return
     */
    Long countByParam(SensitiveWordsPageParam pageParam);

    /**
     * 查询公有的和公司私有的 所有
     *
     * @param companyIds 公司id列表
     * @return
     */
    List<SensitiveWordsDto> listByCompanyIds(List<Long> companyIds);
}
