/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.livecenter.api.exception;

import cn.com.duiba.kjy.livecenter.api.exception.ParamException;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ParamChecker {
    protected static void throwException(String message) {
        throw new ParamException(message);
    }

    public static void checkNotNull(Object o, String message) {
        if (o != null) {
            return;
        }
        ParamChecker.throwException(message);
    }

    public static void checkIsTrue(boolean expression, String message) {
        if (expression) {
            return;
        }
        ParamChecker.throwException(message);
    }

    public static void checkNotBlank(String test, String message) {
        if (StringUtils.isNotBlank((CharSequence)test)) {
            return;
        }
        ParamChecker.throwException(message);
    }

    public static void checkGtZero(Number number, String message) {
        if (number != null) {
            if (number instanceof Integer && (Integer)number > 0) {
                return;
            }
            if (number instanceof Long && (Long)number > 0L) {
                return;
            }
            if (number instanceof Float && ((Float)number).floatValue() > 0.0f) {
                return;
            }
            if (number instanceof Double && (Double)number > 0.0) {
                return;
            }
        }
        ParamChecker.throwException(message);
    }

    public static void checkNotEmpty(Collection collection, String message) {
        if (collection != null && collection.size() > 0) {
            return;
        }
        ParamChecker.throwException(message);
    }

    public static void checkNotEmpty(Map map, String message) {
        if (map != null && map.size() > 0) {
            return;
        }
        ParamChecker.throwException(message);
    }
}

