package cn.com.duiba.kjy.livecenter.api.remoteservice.creditCard;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.conf.CardHolderConfigDto;
import cn.com.duiba.kjy.livecenter.api.dto.creditCard.UserCardHolderDto;

import java.util.List;

/**
 * @author chenhang
 * @date 2021/9/29 3:28 下午
 */
@AdvancedFeignClient
public interface RemoteUserCardHolderService {
    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    UserCardHolderDto findById(Long id);


    /**
     * 新增或者更新数据
     *
     * @param userCardHolder 实例对象
     * @return 影响的行数
     */
    int saveOrUpdate(UserCardHolderDto userCardHolder);

    /**
     * 根据直播用户id获取数据
     * @param liveUserId 直播用户id
     * @return 实体对象
     */
    UserCardHolderDto getByLiveUserId(Long liveUserId);

    /**
     * 根据直播用户ids获取数据
     * @param liveUserIds 直播用户列表
     * @return 列表
     */
    List<UserCardHolderDto> listByLiveUserIds(List<Long> liveUserIds);

    /**
     * 根据公司id获取持卡类型
     * @param companyId 公司id
     * @return 持卡类型
     */
    CardHolderConfigDto getConfigByCompanyId(Long companyId);

}
