package cn.com.duiba.kjy.livecenter.api.remoteservice.task;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.task.TaskConfigDto;

import java.util.List;

/**
 * @Author xujing
 * @Date 2020/11/10 3:46 下午
 */
@AdvancedFeignClient
public interface RemoteTaskConfigService {
    /**
     * 根据直播间类型和直播间id查询所有的任务配置（包含通用和自定义任务）
     * @param liveId 直播间id
     * @param liveType 直播间类型
     * @return
     */
    List<TaskConfigDto> listAllByLiveId(Long liveId, Integer liveType);

    /**
     * 根据id查询
     * @param taskId
     * @return
     */
    TaskConfigDto findById(Long taskId);
}
