package cn.com.duiba.kjy.livecenter.api.remoteservice.wspush;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.wspush.WsSpokeDto;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by dugq on 2020-07-06.
 */
@AdvancedFeignClient
public interface RemoteSpokeSortedSetService {

    /**
     * 批量保存评论
     * @param liveId
     * @param list
     */
    void batchSaveSpoke2Redis(Long liveId, List<WsSpokeDto> list);

    /**
     * 获取最近1s新增的评论
     * @param liveId
     * @return
     */
    List<WsSpokeDto> getRecentlyOneSecondSpokeList(Long liveId);

    /**
     * 获取最近30条评论
     * @param liveId
     * @return
     */
    ArrayList<WsSpokeDto> getRecentlySpokeList(Long liveId);

    /**
     * 获取最近200条评论
     * @param liveId
     * @return
     */
    List<WsSpokeDto> getRecently200SpokeList(Long liveId);
}
