package cn.com.duiba.kjy.livecenter.api.dto.smallshop.order;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;

/**
 * @Author: fss
 * @Date: 2021/9/7 16
 * @Description:
 */
@Data
public class CrossItemDto implements Serializable {
    private static final long serialVersionUID = -1927000864910103346L;

    /**
     * 业务模式，1-保税仓模式
     */
    @JSONField(name = "cross_type")
    private String crossType;

    /**
     * 税费类型，1-商品含税，2-独立计税
     */
    @JSONField(name = "cross_tax_type")
    private String crossTaxType;

    /**
     * 商品税率，如20.01
     */
    @JSONField(name = "cross_tax_rate")
    private String crossTaxRate;

    /**
     * 商品总税费，商品税费+均摊的运费税费
     */
    @JSONField(name = "cross_tax")
    private String crossTax;

    /**
     * 商品完税价格，单位元，针对单个商品
     */
    @JSONField(name = "cross_item_price")
    private String crossItemPrice;

    /**
     * 商品总货值（商品完税价格*商品数量），单位：元
     */
    @JSONField(name = "cross_price")
    private String crossPrice;

    /**
     * 商品均摊的完税运费总和，单位：元
     */
    @JSONField(name = "cross_express_fee")
    private String crossExpressFee;

    /**
     * 退货单号
     */
    @JSONField(name = "return_code")
    private String returnCode;
}
